local ScenarioUtils = import('/lua/sim/ScenarioUtilities.lua')
local ScenarioFramework = import('/lua/ScenarioFramework.lua')

function OnPopulate()
    ScenarioUtils.InitializeArmies()
    ScenarioFramework.SetPlayableArea('AREA_1' , false)
end

function OnStart(scenario)
	local CIV_INV = ScenarioUtils.CreateArmyGroup('NEUTRAL_CIVILIAN', 'INVINCIBLE')
	-- manipulate all civilians
	for i, unit in CIV_INV do
		unit:SetCanBeKilled(false)
		unit:SetCapturable(false)
		unit:SetReclaimable(false)
		unit:SetDoNotTarget(true)
		unit:SetRegenRate(100)
	end
	ForkThread(gatherFeedback)
end

--Startmessage
function gatherFeedback()
    WaitSeconds(10)
    BroadcastMSG('This map has invincible civilians.',  -- message
                 16,                                                             -- fontsize
                 'd0d0d0',                                                       -- color
                 5,                                                             -- duration
                 'center')                                                       -- position
end

function BroadcastMSG(message, fontsize, RGBColor, duration, location)
----------------------------------------
-- broadcast a text message to players
-- possible locations = lefttop, leftcenter, leftbottom,  righttop, rightcenter, rightbottom, rightbottom, centertop, center, centerbottom
----------------------------------------
    PrintText(message, fontsize, 'ff' .. RGBColor, duration , location) ;
end
