options ={

{
    default = 1,
    label = "Dynamic Spawn Of Resources",
    help = "Determine which mexes & hydros should be spawned.",
    key = 'dynamic_spawn',
    pref = 'dynamic_spawn',
    values = {
        { text = "mirror slots", help = "Spawn resources for player & mirror slot (balanced resources).", key = 1, },
        { text = "used slots", help = "Only spawn resources for player on used slots (unbalanced resources).", key = 2, },
        { text = "no mirror = no resources", help = "Only spawn resources if mirror slot is also occupied by a player (not recommended, but it can make uneven matches fairer).", key = 3, },
        { text = "2v2 setup", help = "Don't adjust for player & spawn resources for 2v2.", key = 4, },
        { text = "4v4 setup", help = "Don't adjust for player & spawn resources for 4v4.", key = 5, },
        { text = "5v5 setup", help = "Don't adjust for player & spawn resources for 5v5.", key = 6, },
        { text = "7v7 setup", help = "Don't adjust for player & spawn resources for maximum player count.", key = 7, },
    },
},

{
    default = 1,
    label = "Crazyrush",
    help = "Activate different types of crazyrush* for the spawned mexes. *Building a mex on a mass point will always create new adjacent mass points to build on.",
    key = 'crazyrush_mexes',
    pref = 'crazyrush_mexes',
    values = {
        { text = "disabled", help = "No crazyrush.", key = 1, },
        { text = "crazyrush forward mexes", help = "Activate crazyrush only for 4 mexes in middle of the map. All other mexes will behave normally.", key = 2, },
        { text = "crazyrush 1 core mex", help = "Activate crazyrush & spawn only 1 core mex per active slot.", key = 3, },
        { text = "crazyrush", help = "Activate crazyrush for all spawned mexes.", key = 4, },
    },
},

{
    default = 2,
    label = "Core Mexes",
    help = "Spawn 3 or 4 core mexes.",
    key = 'core_mexes',
    pref = 'core_mexes',
    values = {
        { text = "3", help = "Spawn 3 core mexes.", key = 1, },
        { text = "4", help = "Spawn 4 core mexes.", key = 2, },
    },
},

{
    default = 2,
    label = "Extra Hydros",
    help = "Spawn additional hydros at the civilian positions.",
    key = 'extra_hydros',
    pref = 'extra_hydros',
    values = {
        { text = "0", help = "No extra hydros.", key = 1, },
        { text = "14", help = "Spawn 14 hydros.", key = 2, },
    },
},

{
	default = 3,
	label = "Civilian's",
	help = "Spawn civilian Aeon base structures and defenses at hydro positions.",
	key = 'optional_civilian_defenses',
	pref = 'optional_civilian_defenses',
	values = {
		{ text = "disabled", help = "No civilian base or defenses.", key = 1, },
		{ text = "T1 wrecks (Base)", help = "Spawn civilian T1 Hydro, Power Generator, Radar & Energy Storage wrecks.", key = 2, },
		{ text = "T1 wrecks (PD+AA)", help = "Spawn additional civilian T1 PD & AA wrecks.", key = 3, },
		{ text = "T2 wrecks (PD+TMD)", help = "Spawn additional civilian T2 PD & TMD wrecks.", key = 4, },
		{ text = "T3 wrecks (AA+Shield)", help = "Spawn additional civilian T3 AA & T2 Shield wrecks.", key = 5, },
		{ text = "T1 operational (Base)", help = "Spawn operational civilian T1 Hydro, Power Generator, Radar & Energy Storage.", key = 6, },
		{ text = "T1 operational (PD+AA)", help = "Spawn additional operational civilian T1 PD & AA.", key = 7, },
		{ text = "T2 operational (PD+TMD)", help = "Spawn additional operational civilian T2 PD & TMD .", key = 8, },
		{ text = "T3 operational (AA+Shield)", help = "Spawn additional operational civilian T3 AA & T2 Shield.", key = 9, },
	},
},

{
	default = 2,
	label = "Wreckage",
	help = "Scale amount and tech of Aeon unit wrecks.",
	key = 'optional_wreckage',
	pref = 'optional_wreckage',
	values = {
		{ text = "disabled", help = "No wrecks.", key = 1, },
		{ text = "T1 wrecks", help = "Add T1 wrecks.", key = 2, },
		{ text = "T2 wrecks", help = "Add T2 wrecks.", key = 3, },
		{ text = "T3 wrecks", help = "Add two T3 wrecks to the map center.", key = 4, },
		{ text = "T4 wrecks", help = "Add one Tempest wreck to the map center.", key = 5, },
	},
},

{
	default = 5,
	label = "Natural Reclaim Values",
	help = "Change mass & energy values of rock & tree props.",
	key = 'naturalReclaimModifier',
	pref = 'naturalReclaimModifier',
	--not defined via adaptive script, just determine value via key
	values = {
		{ text = "300 percent", help = "Mass & energy values are 3 times higher.", key = 3, },
		{ text = "200 percent", help = "Mass & energy values are 2 times higher.", key = 2, },
		{ text = "150 percent", help = "Mass & energy values are 1.5 times higher.", key = 1.5, },
		{ text = "125 percent", help = "Mass & energy values are 1.25 times higher.", key = 1.25, },
		{ text = "100 percent", help = "Don't change the mass & energy values.", key = 1, },
		{ text = "75 percent", help = "Mass & energy values are 0.75 times lower.", key = 0.75, },
		{ text = "50 percent", help = "Mass & energy values are 0.5 times lower.", key = 0.5, },
		{ text = "25 percent", help = "Mass & energy values are 0.25 times lower.", key = 0.25, },
		{ text = "0 percent", help = "Remove Mass & energy values from rock & tree props.", key = 0, },
	},
},

{
	default = 1,
	label = "Regrowing Trees",
	help = "Regrow reclaimed/destroyed trees when other trees are nearby. Regrow is faster if more trees are close.",
	key = 'TreeRegrowSpeed',
	pref = 'TreeRegrowSpeed',
	values = {
		{ text = "disabled", help = "No regrowing trees.", key = 1, },
		{ text = "fast", help = "Regrow trees faster.", key = 2, },
		{ text = "enabled", help = "Regrow trees.", key = 3, },
		{ text = "slow", help = "Regrow trees slower.", key = 4, },
	},
},

{
	default = 1,
	label = "Jamming",
	help = "Add a Seraphim jamming crystal to every civilian hydro position, to create false radar signals.",
	key = 'jamming',
	pref = 'jamming',
	values = {
		{ text = "disabled", help = "No jamming.", key = 1, },
		{ text = "enabled", help = "Add a jamming crystal.", key = 2, },
	},
},
};
