------------------------------------------------------------------------
----- Script by CookieNoob and KeyBlue (modified by svenni_badbwoi)-----
------------------------------------------------------------------------
local ScenarioUtils = import('/lua/sim/ScenarioUtilities.lua')
local ScenarioFramework = import('/lua/ScenarioFramework.lua')
local Tables = import('/maps/adaptive_monument_valley.v0005/adaptive_monument_valley_tables.lua')

--determine maximum possible player count via table.lua
local maxPlayerOnMap = Tables.maxPlayerOnMap or 16

--IMPORT: options.lua settings
--chosen key or default key
--resources
local dynamic_spawn = ScenarioInfo.Options.dynamic_spawn or 1
local crazyrush_mexes = ScenarioInfo.Options.crazyrush_mexes or 1
local extra_mexes = ScenarioInfo.Options.extra_mexes or 1
local core_mexes = ScenarioInfo.Options.core_mexes or 2
--units
local optional_wreckage = ScenarioInfo.Options.optional_wreckage or 2
local optional_civilian_base = ScenarioInfo.Options.optional_civilian_base or 3
local optional_civilian_defenses = ScenarioInfo.Options.optional_civilian_defenses or 5
local jamming = ScenarioInfo.Options.jamming or 1

local spawnedMassSpots={}
local spawnedMexNumber = 0

--ensure all core mexes to use/spawn crazyrushOneMexes
if(crazyrush_mexes == 3) then
	core_mexes = 2
end

--stuff for crazyrush script
local currentResSpot = 0
local generatedMass = {}
local checkedExtractor = {}
local MexList ={}


------------------------------------------------------------------------
----- Initialization Part ----------------------------------------------
------------------------------------------------------------------------
--OnPopulate
function OnPopulate()
	LOG("ADAPTIVE: OnPopulate")
	ScenarioUtils.InitializeArmies();
	OptionalUnits();
end

--OnStart
function OnStart()
	LOG("ADAPTIVE: OnStart")
	
	--set color for civilians
	SetArmyColor('ARMY_17',245,203,150)
	
	ForkThread(startCrazyrushLoop)
	
	-- ForkThread(gatherFeedback)
end

--Crazyrush
function startCrazyrushLoop()
    --wait to fix bug with civi mex wrecks activating crazyrush
    WaitSeconds(1)
    
    --activate forward_crazyrush_mexes
    if crazyrush_mexes == 2 then
        LOG("ADAPTIVE: activate Forward Crazyrush Mexes")
        ForkThread(Crazyrush_checkMassPoint, false)
        
    --activate crazyrush 1 mex
    elseif crazyrush_mexes == 3 then
        LOG("ADAPTIVE: activate Crazyrush 1 Mex")
        ForkThread(Crazyrush_checkMassPoint, true)
        
     --activate crazyrush
    elseif crazyrush_mexes == 4 then
        LOG("ADAPTIVE: activate Crazyrush")
        ForkThread(Crazyrush_checkMassPoint, true)
    end
end

-- --Startmessage
-- function gatherFeedback()
	-- WaitSeconds(10)
	-- LOG("ADAPTIVE: gatherFeedback")
	-- BroadcastMSG(
		-- 'If you discover any map-related bugs, pls tell svenni_badbwoi. Thx.',	-- message
		-- 16,																		-- fontsize
		-- 'd0d0d0',																-- color
		-- 5,																		-- duration
		-- 'center')																-- position
-- end


------------------------------------------------------------------------
----- Optional Units (civilians, reclaim, jamming, ...) ----------------
------------------------------------------------------------------------
--call from OnPopulate to prevent despawning map-decal glitch (map-decal disappeared, when optional structures (probably due to decal) and a certain amount of unit footprint/track-decals were spawned)
function OptionalUnits()
	LOG("ADAPTIVE: Optional Units:")
	LOG("ADAPTIVE: optional_wreckage = ", optional_wreckage)
	LOG("ADAPTIVE: optional_civilian_base = ", optional_civilian_base)
	LOG("ADAPTIVE: optional_civilian_defenses = ", optional_civilian_defenses)
	LOG("ADAPTIVE: jamming = ", jamming)
	
	--Land Wreckage
	if optional_wreckage > 1 then
		for w = 2, optional_wreckage do
			ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Wreckage_' .. w, true)
		end
	end
	
	--UEF civi base
    --spawn wreckage
	if(optional_civilian_base == 2) then
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Civilian_Base_2', true)
    --spawn operational
	elseif(optional_civilian_base == 3) then
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Civilian_Base_2', false)
	end
	
	--UEF civi base defenses
	--spawn wreckage
	if(optional_civilian_defenses == 2) then
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Civilian_Defenses_2', true)
	elseif(optional_civilian_defenses == 3) then
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Civilian_Defenses_2', true)
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Civilian_Defenses_3', true)
	elseif(optional_civilian_defenses == 4) then
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Civilian_Defenses_2', true)
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Civilian_Defenses_3', true)
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Civilian_Defenses_4', true)
    --spawn operational
	elseif(optional_civilian_defenses == 5) then
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Civilian_Defenses_2', false)
	elseif(optional_civilian_defenses == 6) then
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Civilian_Defenses_2', false)
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Civilian_Defenses_3', false)
	elseif(optional_civilian_defenses == 7) then
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Civilian_Defenses_2', false)
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Civilian_Defenses_3', false)
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Optional_Civilian_Defenses_4', false)
	end
	
	--Jamming
	if jamming == 2 then
		ScenarioUtils.CreateArmyGroup('ARMY_17', 'Jamming', false)
	end
end


------------------------------------------------------------------------
----- Create Resources -------------------------------------------------
------------------------------------------------------------------------
function ScenarioUtils.CreateResources()
	LOG("ADAPTIVE: Create Resources:")
	LOG("ADAPTIVE: dynamic_spawn = ", dynamic_spawn)
	LOG("ADAPTIVE: crazyrush_mexes = ", crazyrush_mexes)
	LOG("ADAPTIVE: extra_mexes = ", extra_mexes)
	LOG("ADAPTIVE: core_mexes = ", core_mexes)
	
	--get map markers
	local markers = ScenarioUtils.GetMarkers();
	
    --IMPORT: table.lua content (player bound resources + additional resources)
    --it is sorted in such a way that the first line corresponds to player one, the second to player 2 and so on...
	local spwnMexArmy = Tables.spwnMexArmy or {}
	local spwnHydroArmy = Tables.spwnHydroArmy or {}
	local extraMexes = Tables.extraMexes or {}
	local coreMexes = Tables.coreMexes or {}
	local forwardCrazyrushMexes = Tables.forwardCrazyrushMexes or {}
	local crazyrushOneMexes = Tables.crazyrushOneMexes or {}

	
	--find out if there are spots that do not have a mirror
	--in that case store the pair in the list with false
	local numberOfNotPresentArmies = 1
	
	--check which army isnt there
	local Notpresentarmies = {}
	local ArmyList = ListArmies()
	
	--spawn mexes on closed spots if requested
	for j, spawnmex in ScenarioInfo.Options.SpawnMex or {} do
		if spawnmex then
			ArmyList[table.getn(ArmyList) + 1] = 'ARMY_' .. j
		end
	end
	
	--DYNAMIC SPAWN OF RESOURCES
    --mirror slots
    if dynamic_spawn == 1 then
        for m = 1, (maxPlayerOnMap/2) do
            local army1 = (2*m - 1)
            local army2 = (2*m)
            local army1String = "ARMY_" .. army1
            local army2String = "ARMY_" .. army2
            
            --compare 2 armys and find mirrored armys
            local found_Army1 = false
            local found_Army2 = false
            for number, army in ArmyList do
                if army == army1String then
                    found_Army1 = true
                elseif army == army2String then
                    found_Army2 = true
                end
            end
            if found_Army1 == false and found_Army2 == false then
                Notpresentarmies[numberOfNotPresentArmies] = army1;
                numberOfNotPresentArmies = numberOfNotPresentArmies + 1;
                Notpresentarmies[numberOfNotPresentArmies] = army2;
                numberOfNotPresentArmies = numberOfNotPresentArmies + 1;
            end
        end
        
    --used slot
    elseif dynamic_spawn == 2 then
        for armyIndex = 1, maxPlayerOnMap do
            local armyStringA = "ARMY_" .. armyIndex
            local foundArmyOnTheField = false
            for _, armyStringB in ArmyList do
                if( armyStringA == armyStringB ) then
                    foundArmyOnTheField = true
                    break
                end
            end
            if ( not foundArmyOnTheField ) then
                Notpresentarmies[numberOfNotPresentArmies] = armyIndex;
                numberOfNotPresentArmies = numberOfNotPresentArmies + 1;
            end
        end
        
    --no mirror = no resources
    elseif dynamic_spawn == 3 then
        for m = 1, (maxPlayerOnMap/2) do
            local army1 = (2*m - 1)
            local army2 = (2*m)
            local army1String = "ARMY_" .. army1
            local army2String = "ARMY_" .. army2

            local here = 0;
            for number, army in ArmyList do
                if( army == army1String or army == army2String ) then
                    here = here + 1;
                end
            end

            if here < 2 then
                Notpresentarmies[numberOfNotPresentArmies] = army1;
                numberOfNotPresentArmies = numberOfNotPresentArmies + 1;
                Notpresentarmies[numberOfNotPresentArmies] = army2;
                numberOfNotPresentArmies = numberOfNotPresentArmies + 1;
            end
        end
		
	--FIX SETUP FOR X PLAYER
	--3v3 - setup army 1-6
	elseif(dynamic_spawn == 4) then
		for m = 7, maxPlayerOnMap do
			Notpresentarmies[numberOfNotPresentArmies] = m;
			numberOfNotPresentArmies = numberOfNotPresentArmies + 1;
		end
		
	--4v4 - setup armys 1-8
	elseif(dynamic_spawn == 5) then
		for m = 9, maxPlayerOnMap do
			Notpresentarmies[numberOfNotPresentArmies] = m;
			numberOfNotPresentArmies = numberOfNotPresentArmies + 1;
		end
		
	--5v5 - setup armys 1-10
	elseif(dynamic_spawn == 6) then
		for m = 11, maxPlayerOnMap do
			Notpresentarmies[numberOfNotPresentArmies] = m;
			numberOfNotPresentArmies = numberOfNotPresentArmies + 1;
		end
		
	-- 6v6 - setup army 1-12
	elseif(dynamic_spawn == 7) then
		Notpresentarmies = {};
	end
	
	--SPAWN RESOURCES
	--(marker=Mex)
	for name, tblData in pairs(markers) do
	
		--only spawn resources (obviously)
		if (not tblData.resource) then
			doit = false;
		else
			--standard resources, spawn it
			doit = true;
			
			--FalseIfInList = REMOVE/DONT SPAWN MARKER IN LIST
            --remove the spawn when a player is not present, loop over all not present armies and check if the marker for the current mex/hydro is corresponds to one of those in the list
            for _ ,armynumber in Notpresentarmies do
                --loop over all markers of mexes in the table of the row of the missing army
                doit=FalseIfInList(name, spwnMexArmy[armynumber], MassString, doit);
                doit=FalseIfInList(name, spwnHydroArmy[armynumber], HydroString, doit);
            end
			
			--LOG("ADAPTIVE: extraMexes table items = ", table.getn(extraMexes))
			for e = extra_mexes, table.getn(extraMexes) do
                doit=FalseIfInList(name, extraMexes[e], MassString, doit);
				-- LOG("ADAPTIVE: removing extraMexes")
            end
			
			--LOG("ADAPTIVE: coreMexes table items = ", table.getn(coreMexes))
            for e = core_mexes, table.getn(coreMexes) do
				doit=FalseIfInList(name, coreMexes[e], MassString, doit);
				--LOG("ADAPTIVE: removing coreMexes")
			end
			
			--FalseIfNotInList = ONLY USE MARKER IN LIST
			--use only "crazyrushOneMexes"
			if crazyrush_mexes == 3 then
				doit = FalseIfNotInList(name, crazyrushOneMexes, MassString, doit);
				--LOG("ADAPTIVE: only crazyrushOneMexes")
			end
		end
		
		if (doit) then
			if(tblData.type == 'Mass') then
				spawnedMexNumber = spawnedMexNumber + 1
				spawnedMassSpots[spawnedMexNumber] = name
			end
			
			--enable 'forwardCrazyrushMexes'
			if crazyrush_mexes == 2 and FalseIfNotInList(name, forwardCrazyrushMexes, MassString, true) then
				spawnresource(tblData.position,tblData.type, false)
			else
				spawnresource(tblData.position,tblData.type, true)
			end
		end
	end
end

function MassString(_mexname)
	if type(_mexname) == 'string' then
		return "Mass " .. _mexname;
	end
	
	if(_mexname > 9) then
		return "Mass " .. _mexname;
	else
		return "Mass 0" .. _mexname;
	end
end

function HydroString(_hydroname)
	if type(_hydroname) == 'string' then
		return "Hydrocarbon " .. _hydroname;
	end
	
	if(_hydroname > 9) then
		return "Hydrocarbon " .. _hydroname;
	else
		return "Hydrocarbon 0" .. _hydroname;
	end
end

function FalseIfInList(name,list, string_function, _doit)
	for k = 1, table.getn(list) do
		if(name == (string_function(list[k]))) then
			return false
		end
	end
	return _doit;
end

function FalseIfNotInList(name, list, string_function, _doit)
	for k = 1, table.getn(list) do
		if(name == (string_function(list[k]))) then
			return _doit
		end
	end
	return false
end

function spawnresource(Position,restype, spawnhpr)
	--check type of resource and set parameters
	local bp, albedo, size, lod;
	if restype == "Mass" then
		albedo = "/env/common/splats/mass_marker.dds";
		bp = "/env/common/props/massDeposit01_prop.bp";
		size = 2;
		lod = 100;
	else
		albedo = "/env/common/splats/hydrocarbon_marker.dds";
		bp = "/env/common/props/hydrocarbonDeposit01_prop.bp";
		size = 6;
		lod = 200;
	end
	
	--create the resource
	CreateResourceDeposit(restype,	Position[1], Position[2], Position[3], size/2);
	
    --create the resource graphic on the map
    if spawnhpr then
        CreatePropHPR(bp, Position[1], Position[2], Position[3], Random(0,360), 0, 0);
    end
    --create the resource icon on the map
    CreateSplat(
        Position,                # Position
        0,                       # Heading (rotation)
        albedo,                  # Texture name for albedo
        size, size,              # SizeX/Z
        lod,                     # LOD
        0,                       # Duration (0 == does not expire)
        -1,                      # Army (-1 == not owned by any single army)
        0                        # Fidelity
    );
end


------------------------------------------------------------------------
----- Message part -----------------------------------------------------
------------------------------------------------------------------------
function BroadcastMSG(message, fontsize, RGBColor, duration, location)
----------------------------------------
-- broadcast a text message to players
-- possible locations = lefttop, leftcenter, leftbottom,  righttop, rightcenter, rightbottom, rightbottom, centertop, center, centerbottom
----------------------------------------
	PrintText(message, fontsize, 'ff' .. RGBColor, duration , location) ;
end


------------------------------------------------------------------------
----- Crazyrush part ---------------------------------------------------
------------------------------------------------------------------------
function Crazyrush_checkMassPoint(AllOrList)
	if(AllOrList) then
		while(true)do
			local units = GetUnitsInRect({x0 = 0, x1 = ScenarioInfo.size[1], y0 = 0, y1 = ScenarioInfo.size[2]})
			if(units~=nil)then
				for i,unit in units do
					if(EntityCategoryContains(categories.MASSEXTRACTION,unit))then
						posx = unit:GetPosition()[1]
						posy = unit:GetPosition()[3]
						if(not Crazyrush_alreadyCheckedExtractor(posx, posy))then
							Crazyrush_GenerateResourcesMarker(posx - 2, posy)
							Crazyrush_GenerateResourcesMarker(posx + 2, posy)
							Crazyrush_GenerateResourcesMarker(posx, posy - 2)
							Crazyrush_GenerateResourcesMarker(posx, posy + 2)
							WaitSeconds( 0.001 )
						end
					end
				end
			end
			WaitSeconds( 1 )
		end
	else
		local forwardCrazyrushMexes = Tables.forwardCrazyrushMexes or {}
		if(table.getn(forwardCrazyrushMexes)== 0) then
			return 0
		else
			for marker,markerpointer in pairs(ScenarioUtils.GetMarkers()) do
				if FalseIfNotInList(marker, forwardCrazyrushMexes, MassString, true) then
					MexList[table.getn(MexList) + 1]= {markerpointer.position[1], markerpointer.position[3]}
					CreatePropHPR('/env/common/props/hydrocarbonDeposit01_prop.bp', markerpointer.position[1],
								  GetTerrainHeight(markerpointer.position[1], markerpointer.position[3]),
								  markerpointer.position[3], Random(0,360), 0, 0)
				end
			end
			while(true) do
				for _, marker in MexList do
					local units = GetUnitsInRect({x0 = marker[1] - 0.2, x1 = marker[1] + 0.2, y0 = marker[2] - 0.2, y1 = marker[2] + 0.2}) or {}
					for _,unit in units or {} do
						if EntityCategoryContains(categories.MASSEXTRACTION, unit) then
							posx = unit:GetPosition()[1]
							posy = unit:GetPosition()[3]
							if(posx == marker[1] and posy == marker[2] ) then
								if(not Crazyrush_alreadyCheckedExtractor(posx, posy))then
									Crazyrush_GenerateResourcesMarker(posx - 2, posy)
									Crazyrush_GenerateResourcesMarker(posx + 2, posy)
									Crazyrush_GenerateResourcesMarker(posx, posy - 2)
									Crazyrush_GenerateResourcesMarker(posx, posy + 2)
									WaitSeconds( 0.001 )
								end
							end
						end
					end
				end
				WaitSeconds( 1 )
			end
		end
	end
end

function Crazyrush_alreadyCheckedExtractor(x,y)
	local foundIt = false
	if(checkedExtractor[x]==nil)then
		checkedExtractor[x]={}
		checkedExtractor[x][y] = true
	else
		if(checkedExtractor[x][y]==nil)then
			checkedExtractor[x][y] = true
		else
			foundIt = true
		end
	end
	return foundIt
end

function Crazyrush_GenerateResourcesMarker(x, y)
	local foundIt = false
	if(generatedMass[x]==nil)then
		generatedMass[x]={}
		generatedMass[x][y] = true
	else
		if(generatedMass[x][y]==nil)then
			generatedMass[x][y] = true
		else
			foundIt = true
		end
	end
	
	if(not foundIt)then
		tmptable = {x, y}
		table.insert(generatedMass, tmptable)
		marker =
		{
			['Mass '..(300 + currentResSpot)] =
			{
				['type'] = STRING( 'Mass' ),
				['position'] = VECTOR3( x, GetTerrainHeight(x,y), y ),
				['orientation'] = VECTOR3( 0.00, 0.00, 0.00 ),
				['size'] = FLOAT( 1.00 ),
				['resource'] = BOOLEAN( true ),
				['amount'] = FLOAT( 100.00 ),
				['color'] = STRING( 'ff808080' ),
				['editorIcon'] = STRING( '/textures/editor/marker_mass.bmp' ),
				['prop'] = STRING( '/env/common/props/markers/M_Mass_prop.bp' ),
			},
		}
		currentResSpot = currentResSpot + 1
		Crazyrush_CreateResources(marker)
		MexList[table.getn(MexList)+1] = tmptable
	end
end

function Crazyrush_CreateResources(markers)
	--local markers = GetMarkers()
	for i, tblData in pairs(markers) do
		if tblData.resource then
			spawnresource(tblData.position, tblData.type, true)
		end
	end
end
