options ={

{
    default = 1,
    label = "Dynamic Spawn Of Resources",
    help = "Determine which mexes & hydros should be spawned.",
    key = 'dynamic_spawn',
    pref = 'dynamic_spawn',
    values = {
        { text = "mirror slots", help = "Spawn resources for player & mirror slot (balanced resources).", key = 1, },
        { text = "used slots", help = "Only spawn resources for player on used slots (unbalanced resources).", key = 2, },
        { text = "no mirror = no resources", help = "Only spawn resources if mirror slot is also occupied by a player (not recommended, but it can make uneven matches fairer).", key = 3, },
        { text = "2v2 setup", help = "Don't adjust for player & spawn resources for 2v2.", key = 4, },
        { text = "3v3 setup", help = "Don't adjust for player & spawn resources for 3v3.", key = 5, },
        { text = "4v4 setup", help = "Don't adjust for player & spawn resources for 4v4.", key = 6, },
        { text = "5v5 setup", help = "Don't adjust for player & spawn resources for 5v5.", key = 7, },
        { text = "6v6 setup", help = "Don't adjust for player & spawn resources for maximum player count.", key = 8, },
    },
},

{
    default = 1,
    label = "Crazyrush",
    help = "Activate different types of crazyrush* for the spawned mexes. *Building a mex on a mass point will always create new adjacent mass points to build on.",
    key = 'crazyrush_mexes',
    pref = 'crazyrush_mexes',
    values = {
        { text = "disabled", help = "No crazyrush.", key = 1, },
        { text = "crazyrush forward mexes", help = "Activate crazyrush only for 4 mexes on the diagonal center line. All other mexes will behave normally.", key = 2, },
        { text = "crazyrush 1 core mex", help = "Activate crazyrush & spawn only 1 core mex per active slot.", key = 3, },
        { text = "crazyrush", help = "Activate crazyrush for all spawned mexes.", key = 4, },
    },
},

{
    default = 2,
    label = "Core Mexes",
    help = "Spawn 3 or 4 core mexes in ACU build range.",
    key = 'core_mexes',
    pref = 'core_mexes',
    values = {
        { text = "3", help = "Spawn 3 core mexes.", key = 1, },
        { text = "4", help = "Spawn 4 core mexes.", key = 2, },
    },
},

-- {
	-- default = 1,
	-- label = "Extra Mexes",
	-- help = "Spawn 4 additional mexes. 1 each in outer riverbed.",
	-- key = 'extra_mexes',
	-- pref = 'extra_mexes',
	-- values = {
        -- { text = "0", help = "No extra mexes.", key = 1, },
        -- { text = "4", help = "Add 4 extra mexes.", key = 2, },
	-- },
-- },

-- {
	-- default = 2,
	-- label = "Civilian Base",
	-- help = "Spawn civilian Aeon base in the middle of the map.",
	-- key = 'optional_civilian_base',
	-- pref = 'optional_civilian_base',
	-- values = {
		-- { text = "disabled", help = "No civilian base.", key = 1, },
		-- { text = "wreckage", help = "Spawn civilian base wreckage.", key = 2, },
		-- { text = "operational", help = "Spawn operational civilian base.", key = 3, },
	-- },
-- },

{
	default = 5,
	label = "Civilian Defenses",
	help = "Spawn civilian UEF defenses in the middle of the map.",
	key = 'optional_civilian_defenses',
	pref = 'optional_civilian_defenses',
	values = {
		{ text = "disabled", help = "No civilian defenses.", key = 1, },
		{ text = "T1 wrecks (PD+AA)", help = "Spawn civilian T1 PD & AA wrecks. Includes T1 Radar, Hydro & Energy Storage.", key = 2, },
		{ text = "T2 wrecks (PD+AA+TMD+Shield)", help = "Spawn civilian T2 PD, AA, TMD & Shield wrecks in addition to T1. Includes additional T1 Power Generators for Shield.", key = 3, },
		{ text = "T3 wrecks (AA+Shield)", help = "Spawn civilian T3 PD & AA wrecks in addition to T1 & T2. ", key = 4, },
		{ text = "T1 operational (PD+AA)", help = "Spawn operational civilian T1 PD & AA. Includes T1 Radar, Hydro & Energy Storage.", key = 5, },
		{ text = "T2 operational (PD+AA+TMD+Shield)", help = "Spawn operational civilian T2 PD, AA, TMD & Shield in addition to T1. Includes additional T1 Power Generators for Shield.", key = 6, },
		{ text = "T3 operational (PD+AA)", help = "Spawn operational civilian T3 PD & AA in addition to T1 & T2. ", key = 7, },
	},
},

{
	default = 1,
	label = "Satellite Wreck",
	help = "Add a T4 Defense Satellite wreck to the map center (8100 mass).",
	key = 'optional_wreckage',
	pref = 'optional_wreckage',
	values = {
		{ text = "disabled", help = "No T4 Defense Satellite wreck.", key = 1, },
		-- { text = "T1 wrecks", help = "Add T1 wrecks.", key = 2, },
		-- { text = "T2 wrecks", help = "Add T2 wrecks to T1.", key = 3, },
		-- { text = "T3 wrecks", help = "Add T3 wrecks to T1 & T2.", key = 4, },
		{ text = "T4 wreck", help = "Add a T4 Defense Satellite wreck to the map center (8100 mass).", key = 2, },
	},
},

-- {
	-- default = 2,
	-- label = "Naval Wreckage",
	-- help = "Scale amount of naval unit wrecks.",
	-- key = 'optional_naval_wreckage',
	-- pref = 'optional_naval_wreckage',
	-- values = {
		-- { text = "disabled", help = "No naval wrecks.", key = 1, },
		-- { text = "T1 wrecks", help = "Add 8 T1 Frigate wrecks.", key = 2, },
		-- { text = "T2 wrecks", help = "Add 8 T2 Destroyer wrecks to T1.", key = 3, },
		-- { text = "T3 wrecks", help = "Add 2 T3 Battleship wrecks to T1 & T2.", key = 4, },
	-- },
-- },

{
	default = 5,
	label = "Natural Reclaim Values",
	help = "Change mass & energy values of rock & tree props.",
	key = 'naturalReclaimModifier',
	pref = 'naturalReclaimModifier',
	--not defined via adaptive script, just determine value via key
	values = {
		{ text = "300 percent", help = "Mass & energy values are 3 times higher.", key = 3, },
		{ text = "200 percent", help = "Mass & energy values are 2 times higher.", key = 2, },
		{ text = "150 percent", help = "Mass & energy values are 1.5 times higher.", key = 1.5, },
		{ text = "125 percent", help = "Mass & energy values are 1.25 times higher.", key = 1.25, },
		{ text = "100 percent", help = "Don't change the mass & energy values.", key = 1, },
		{ text = "75 percent", help = "Mass & energy values are 0.75 times lower.", key = 0.75, },
		{ text = "50 percent", help = "Mass & energy values are 0.5 times lower.", key = 0.5, },
		{ text = "25 percent", help = "Mass & energy values are 0.25 times lower.", key = 0.25, },
		{ text = "0 percent", help = "Remove Mass & energy values from rock & tree props.", key = 0, },
	},
},

-- {
	-- default = 1,
	-- label = "Regrowing Trees",
	-- help = "Regrow reclaimed/destroyed trees when other trees are nearby. Regrow is faster if more trees are close.",
	-- key = 'TreeRegrowSpeed',
	-- pref = 'TreeRegrowSpeed',
	-- values = {
		-- { text = "disabled", help = "No regrowing trees.", key = 1, },
		-- { text = "fast", help = "Regrow trees faster.", key = 2, },
		-- { text = "enabled", help = "Regrow trees.", key = 3, },
		-- { text = "slow", help = "Regrow trees slower.", key = 4, },
	-- },
-- },

{
	default = 1,
	label = "Jamming",
	help = "Add Seraphim jamming crystal to map center, to create false radar signals.",
	key = 'jamming',
	pref = 'jamming',
	values = {
		{ text = "disabled", help = "No jamming.", key = 1, },
		{ text = "enabled", help = "Add a jamming crystal.", key = 2, },
	},
},
};
