#****************************************************************************
#**
#**  File     : /maps/X1MP14_E3corner/X1MP14_E3corner_script.lua
#**  Author(s): David Tomandl
#**
#**  Summary  : Script for custom E3 map
#**
#**  Copyright 2007 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
local BaseManager = import('/lua/ai/opai/basemanager.lua')
local Behaviors = import('/lua/ai/opai/OpBehaviors.lua')
local Cinematics = import('/lua/cinematics.lua')
local Objectives = import('/lua/ScenarioFramework.lua').Objectives
#local OpStrings = import('/maps/X1MP14_E3corner/X1MP14_E3corner_strings.lua')
local PingGroups = import('/lua/ScenarioFramework.lua').PingGroups
local ScenarioFramework = import('/lua/ScenarioFramework.lua')
local ScenarioPlatoonAI = import('/lua/ScenarioPlatoonAI.lua')
local ScenarioUtils = import('/lua/sim/ScenarioUtilities.lua')
local Utilities = import('/lua/utilities.lua')
local TauntManager = import('/lua/TauntManager.lua')

local ScriptFile = '/maps/X1MP14_E3corner/X1MP14_E3corner_script.lua'
local SPAIFileName = '/lua/scenarioplatoonai.lua'

local PrefetchUtils = import('/lua/sim/PrefetchUtilities.lua')
local PFSet = PrefetchUtils.CreatePrefetchSetFromArmy('Seraphim')
local Fetcher = CreatePrefetchSet()

# -------
# Globals
# -------
ScenarioInfo.Player = 1
ScenarioInfo.Seraphim = 2
ScenarioInfo.Cybran = 3

# ------
# Locals
# ------
local Player = ScenarioInfo.Player
local Seraphim = ScenarioInfo.Seraphim
local Cybran = ScenarioInfo.Cybran

# Track our scripted events through button presses
local TimesPressed = 0
local NukesKilled = 0

# Templates for the factories to endlessly build
local PlayerLandPlatoonTemplate = {
    '',
    '',
    { 'uel0201', 1, 1000000, 'attack', 'none' },
}

local PlayerAirPlatoonTemplate = {
    '',
    '',
    { 'uea0203', 1, 1000000, 'attack', 'none' },
}

local SeraphimLandT1PlatoonTemplate = {
    '',
    '',
    { 'xsl0104', 1, 1000000, 'attack', 'none' },
}

local SeraphimLandT2PlatoonTemplate = {
    '',
    '',
    { 'xsl0201', 1, 1000000, 'attack', 'none' },
}

local SeraphimLandT3PlatoonTemplate = {
    '',
    '',
    { 'xsl0303', 1, 1000000, 'attack', 'none' },
}

# -------
# Startup
# -------
function OnPopulate(scenario)
    ScenarioUtils.InitializeScenarioArmies()

    # Army Colors
    ScenarioFramework.SetUEFColor(Player)
    ScenarioFramework.SetCybranColor(Cybran)
    #ScenarioFramework.SetSeraphimColor(Seraphim)

    SetArmyUnitCap(Seraphim, 1000)
    SetArmyUnitCap(Player, 1000)

    ScenarioInfo.PlayerNuke1 = ScenarioUtils.CreateArmyUnit( 'Player', 'Player_Nuke_1' )
    ScenarioInfo.PlayerNuke1:AddProjectileDamagedCallback( CallMovieHere )
    ScenarioInfo.PlayerNuke1:GiveNukeSiloAmmo(2)

    ScenarioInfo.PlayerNuke2 = ScenarioUtils.CreateArmyUnit( 'Player', 'Player_Nuke_2' )
    ScenarioInfo.PlayerNuke2:AddProjectileDamagedCallback( CallMovieHere )
    ScenarioInfo.PlayerNuke2:GiveNukeSiloAmmo(2)

    ScenarioInfo.PlayerNuke3 = ScenarioUtils.CreateArmyUnit( 'Player', 'Player_Nuke_3' )
    ScenarioInfo.PlayerNuke3:AddProjectileDamagedCallback( CallMovieHere )
    ScenarioInfo.PlayerNuke3:GiveNukeSiloAmmo(2)

    ScenarioInfo.Commander = ScenarioUtils.CreateArmyUnit( 'Player', 'Commander' )
    ScenarioInfo.Commander:SetCanTakeDamage( false )
    ScenarioInfo.Commander:SetCanBeKilled( false )

    ScenarioInfo.PatrolNEGround = ScenarioUtils.CreateArmyGroup('Seraphim', 'Patrol_NE_Ground_1')
    ScenarioInfo.PatrolNEAir = ScenarioUtils.CreateArmyGroup('Seraphim', 'Patrol_NE_Air_1')
    ScenarioInfo.PatrolSWGround = ScenarioUtils.CreateArmyGroup('Seraphim', 'Patrol_SW_Ground_1')
    ScenarioInfo.PatrolSWAir = ScenarioUtils.CreateArmyGroup('Seraphim', 'Patrol_SW_Air_1')
    ScenarioInfo.PatrolPlayerGround = ScenarioUtils.CreateArmyGroup('Player', 'Patrol_Ground_1')
    ScenarioInfo.PatrolPlayerAir = ScenarioUtils.CreateArmyGroup('Player', 'Patrol_Air_1')

end

function OnStart(self)
    Utilities.UserConRequest('SallyShears')
    Utilities.UserConRequest('UI_RenderUnitBars false')
    Utilities.UserConRequest('ren_skydome')
    #Utilities.UserConRequest('ren_skycube')
    ForkThread( DisableMapImager )

    # IssueBuildFactory?  Need to get factories looking busy.

    # These are all of the patrols to add some movement and life to the various bases
    IssuePatrol( ScenarioInfo.PatrolNEGround, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_1_1' ))
    IssuePatrol( ScenarioInfo.PatrolNEGround, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_1_2' ))
    IssuePatrol( ScenarioInfo.PatrolNEGround, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_1_3' ))
    IssuePatrol( ScenarioInfo.PatrolNEGround, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_1_4' ))
    IssuePatrol( ScenarioInfo.PatrolNEGround, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_1_5' ))

    IssuePatrol( ScenarioInfo.PatrolNEAir, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_Air_1_1' ))
    IssuePatrol( ScenarioInfo.PatrolNEAir, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_Air_1_2' ))
    IssuePatrol( ScenarioInfo.PatrolNEAir, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_Air_1_3' ))
    IssuePatrol( ScenarioInfo.PatrolNEAir, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_Air_1_4' ))
    IssuePatrol( ScenarioInfo.PatrolNEAir, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_Air_1_5' ))
    IssuePatrol( ScenarioInfo.PatrolNEAir, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_Air_1_6' ))

    IssuePatrol( ScenarioInfo.PatrolSWGround, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_2_1' ))
    IssuePatrol( ScenarioInfo.PatrolSWGround, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_2_2' ))
    IssuePatrol( ScenarioInfo.PatrolSWGround, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_2_3' ))
    IssuePatrol( ScenarioInfo.PatrolSWGround, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_2_4' ))
    IssuePatrol( ScenarioInfo.PatrolSWGround, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_2_5' ))

    IssuePatrol( ScenarioInfo.PatrolSWAir, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_Air_2_1' ))
    IssuePatrol( ScenarioInfo.PatrolSWAir, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_Air_2_2' ))
    IssuePatrol( ScenarioInfo.PatrolSWAir, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_Air_2_3' ))
    IssuePatrol( ScenarioInfo.PatrolSWAir, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_Air_2_4' ))
    IssuePatrol( ScenarioInfo.PatrolSWAir, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_Air_2_5' ))
    IssuePatrol( ScenarioInfo.PatrolSWAir, ScenarioUtils.MarkerToPosition( 'Seraphim_Patrol_Air_2_6' ))

    IssuePatrol( ScenarioInfo.PatrolPlayerGround, ScenarioUtils.MarkerToPosition( 'Player_Patrol_1_1' ))
    IssuePatrol( ScenarioInfo.PatrolPlayerGround, ScenarioUtils.MarkerToPosition( 'Player_Patrol_1_2' ))
    IssuePatrol( ScenarioInfo.PatrolPlayerGround, ScenarioUtils.MarkerToPosition( 'Player_Patrol_1_3' ))
    IssuePatrol( ScenarioInfo.PatrolPlayerGround, ScenarioUtils.MarkerToPosition( 'Player_Patrol_1_4' ))

    IssuePatrol( ScenarioInfo.PatrolPlayerAir, ScenarioUtils.MarkerToPosition( 'Player_Patrol_Air_1_1' ))
    IssuePatrol( ScenarioInfo.PatrolPlayerAir, ScenarioUtils.MarkerToPosition( 'Player_Patrol_Air_1_2' ))
    IssuePatrol( ScenarioInfo.PatrolPlayerAir, ScenarioUtils.MarkerToPosition( 'Player_Patrol_Air_1_3' ))
    IssuePatrol( ScenarioInfo.PatrolPlayerAir, ScenarioUtils.MarkerToPosition( 'Player_Patrol_Air_1_4' ))

    local BaseUnits = GetUnitsInRect( ScenarioUtils.AreaToRect( 'UEF_Base_Area' ))
    for k, unit in BaseUnits do
        local id = unit:GetUnitId()
        if string.find( id, "ueb1" ) then
            unit:AdjustHealth( unit, unit:GetHealth() / 2 * -1 )
        end
    end

    local LandFactory1 = ScenarioInfo.UnitNames[Player]['Land_Factory_1']
    local LandFactory2 = ScenarioInfo.UnitNames[Player]['Land_Factory_2']
    local LandFactory3 = ScenarioInfo.UnitNames[Player]['Land_Factory_3']

    local AirFactory1 = ScenarioInfo.UnitNames[Player]['Air_Factory_1']
    local AirFactory2 = ScenarioInfo.UnitNames[Player]['Air_Factory_2']
    local AirFactory3 = ScenarioInfo.UnitNames[Player]['Air_Factory_3']

    # Set the factories building units forever
    for k, factory in ArmyBrains[Player]:GetListOfUnits( categories.FACTORY * categories.LAND, false ) do
        ArmyBrains[Player]:BuildPlatoon( PlayerLandPlatoonTemplate, {factory}, 1 )
    end
    for k, factory in ArmyBrains[Player]:GetListOfUnits( categories.FACTORY * categories.AIR, false ) do
        ArmyBrains[Player]:BuildPlatoon( PlayerAirPlatoonTemplate, {factory}, 1 )
    end
    for k, factory in ArmyBrains[Seraphim]:GetListOfUnits( categories.FACTORY * categories.LAND * categories.TECH1, false ) do
        ArmyBrains[Player]:BuildPlatoon( SeraphimLandT1PlatoonTemplate, {factory}, 1 )
    end
    for k, factory in ArmyBrains[Seraphim]:GetListOfUnits( categories.FACTORY * categories.LAND * categories.TECH2, false ) do
        ArmyBrains[Player]:BuildPlatoon( SeraphimLandT2PlatoonTemplate, {factory}, 1 )
    end
    for k, factory in ArmyBrains[Seraphim]:GetListOfUnits( categories.FACTORY * categories.LAND * categories.TECH3, false ) do
        ArmyBrains[Player]:BuildPlatoon( SeraphimLandT3PlatoonTemplate, {factory}, 1 )
    end

    # Then delete any units that get made the instant they are done
    for k, factory in ArmyBrains[Player]:GetListOfUnits( categories.FACTORY, false ) do
        ScenarioFramework.CreateUnitBuiltTrigger( UnitDone, factory, categories.ALLUNITS )
    end
    for k, factory in ArmyBrains[Seraphim]:GetListOfUnits( categories.FACTORY, false ) do
        ScenarioFramework.CreateUnitBuiltTrigger( UnitDone, factory, categories.ALLUNITS )
    end

    #ForkThread( PauseFactories, {LandFactory1, LandFactory2, LandFactory3, AirFactory1, AirFactory2, AirFactory3,})
end

function UnitDone( factory, unit )
    unit:Destroy()
end

#function PauseFactories( factories )
#    WaitSeconds(1)
#    IssuePause( factories )
#end

# This disables the graphic on the edge of the map
function DisableMapImager()
    Utilities.UserConRequest('ren_MapImager')
end

# This will allow the person giving the demo access to all of the functions via one hotkey
function OnShiftF3()
    if TimesPressed == 0 then
        ForkThread( FirstFight )
    elseif TimesPressed == 1 then
        ForkThread( NavalAttack )
    elseif TimesPressed == 2 then
        ForkThread( LaunchFighters )
    elseif TimesPressed == 3 then
        ForkThread( SpawnSWBattle )
    elseif TimesPressed == 4 then
        ForkThread( CybranNaval )
    elseif TimesPressed == 5 then
        ForkThread( SeraphimTransports )
    elseif TimesPressed == 6 then
        ForkThread( SendBomber1 )
    elseif TimesPressed == 7 then
        ForkThread( SendNukes )
    elseif TimesPressed == 8 then
        ForkThread( SendBomber2 )
    elseif TimesPressed == 9 then
        EndDemo()
    end

    TimesPressed = TimesPressed + 1
end

# Spawn the first fight, with Seraphim to the NE of the central UEF base
# Used to be ShiftF3
function FirstFight()

    # Seraphim spawn in and move to the battle area
    local EnemyGroup1 = ScenarioUtils.CreateArmyGroup('Seraphim', 'Fighting_Group_1')
    OffsetMove( EnemyGroup1, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))
#    OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Seraphim_Final_Destination' ))

    local units = ScenarioUtils.CreateArmyGroup('Seraphim', 'Fighting_Group_7')
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))
#    OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Seraphim_Final_Destination' ))

    units = ScenarioUtils.CreateArmyGroup('Seraphim', 'Fighting_Group_9')
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))
#    OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Seraphim_Final_Destination' ))

    units = ScenarioUtils.CreateArmyGroup('Seraphim', 'Fighting_Group_10')
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))
#    OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Seraphim_Final_Destination' ))

    # UEF spawn in and move to the battle area
    ScenarioInfo.BomberTarget = ScenarioUtils.CreateArmyUnit( 'Player', 'Bomber_Target' )
    ScenarioInfo.BomberTarget:SetCanTakeDamage( false )
    ScenarioInfo.BomberTarget:SetCanBeKilled( false )
    ScenarioFramework.CreateUnitDeathTrigger(MakeCrabFragile, ScenarioInfo.BomberTarget)
    units = ScenarioUtils.CreateArmyGroup('Player', 'Fighting_Group_1')
    table.insert( units, ScenarioInfo.BomberTarget )
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))
    #OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_1' ))

    units = ScenarioUtils.CreateArmyGroup('Player', 'Air_Group_2')
    for k, unit in units do
        IssueAttack({ unit }, EnemyGroup1[Random( 1, 10 )])
    end
end

# Spawn the Seraphim naval units and have them attack the naval base
function NavalAttack()

    # Seraphim spawn in
    ScenarioInfo.SeraphimCruisers = ScenarioUtils.CreateArmyGroup('Seraphim', 'Naval_Group_1')
    ScenarioInfo.SeraphimCarrier = ScenarioUtils.CreateArmyUnit( 'Seraphim', 'Carrier' )
    ScenarioInfo.SeraphimFighters = ScenarioUtils.CreateArmyGroup('Seraphim', 'Air_Group_1')

    # Load up the aircraft carriers with anti-air planes
    #IssueTransportLoad(ScenarioInfo.SeraphimFighters, ScenarioInfo.SeraphimCarrier)
    for k, unit in ScenarioInfo.SeraphimFighters do
        #IssueTransportLoad({unit}, ScenarioInfo.SeraphimCarrier)
        ScenarioInfo.SeraphimCarrier:AddUnitToStorage( unit )
    end

    IssueAggressiveMove({ ScenarioInfo.SeraphimCarrier }, ScenarioUtils.MarkerToPosition( 'Seraphim_Naval_Path_1' ))
    OffsetAggressiveMove( ScenarioInfo.SeraphimCruisers, ScenarioUtils.MarkerToPosition( 'Seraphim_Naval_Path_3' ))

    # UEF air spawns in
    local units = ScenarioUtils.CreateArmyGroup('Player', 'Air_Group_1')
end

# Have the aircraft carrier launch Air Superiority fighters
function LaunchFighters()

    ForkThread(LaunchAir)
end

function LaunchAir()
    #LOG('*DEBUG: Launching air from carrier')
    IssueClearCommands({ScenarioInfo.SeraphimCarrier})
    IssueTransportUnload({ScenarioInfo.SeraphimCarrier}, ScenarioInfo.SeraphimCarrier:GetPosition())
    WaitSeconds(10)
    IssueAggressiveMove( {ScenarioInfo.SeraphimCarrier}, ScenarioUtils.MarkerToPosition( 'Seraphim_Naval_Path_1' ))

    IssueClearCommands( ScenarioInfo.SeraphimFighters )
    IssueAggressiveMove( ScenarioInfo.SeraphimFighters, ScenarioUtils.MarkerToPosition( 'Seraphim_Naval_Path_1' ))
    IssueAggressiveMove( ScenarioInfo.SeraphimFighters, ScenarioUtils.MarkerToPosition( 'Seraphim_Naval_Path_2' ))
    IssuePatrol( ScenarioInfo.SeraphimFighters, ScenarioUtils.MarkerToPosition( 'Seraphim_Air_Patrol_1_1' ))
    IssuePatrol( ScenarioInfo.SeraphimFighters, ScenarioUtils.MarkerToPosition( 'Seraphim_Air_Patrol_1_2' ))
    IssuePatrol( ScenarioInfo.SeraphimFighters, ScenarioUtils.MarkerToPosition( 'Seraphim_Air_Patrol_1_3' ))
    IssuePatrol( ScenarioInfo.SeraphimFighters, ScenarioUtils.MarkerToPosition( 'Seraphim_Air_Patrol_1_4' ))
end

# Seraphim attack from SW.  UEF respond, and Cybran arrive.
function SpawnSWBattle()

    # Four groups of Seraphim
    local units = ScenarioUtils.CreateArmyGroup('Seraphim', 'Fighting_Group_2')
    #IssueFormMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_2_2' ), 'AttackFormation', 0 )
    #IssueFormAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_2_4' ), 'AttackFormation', 0 )
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_2_1' ))
    #OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_2_4' ))

    units = ScenarioUtils.CreateArmyGroup('Seraphim', 'Fighting_Group_3')
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_2_1' ))
    #OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_2_4' ))

    units = ScenarioUtils.CreateArmyGroup('Seraphim', 'Fighting_Group_4')
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_2_1' ))
    #OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_2_4' ))

    units = ScenarioUtils.CreateArmyGroup('Seraphim', 'Fighting_Group_5')
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_2_1' ))
    #OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_2_4' ))

    # UEF spawn in and patrol
    ScenarioInfo.UEFUnits = ScenarioUtils.CreateArmyGroup('Player', 'Fighting_Group_2')
    OffsetAggressiveMove( ScenarioInfo.UEFUnits, ScenarioUtils.MarkerToPosition( 'Cybran_Path_7' ))

    ScenarioInfo.CybranUnits = ScenarioUtils.CreateArmyGroup( 'Cybran', 'Fighting_Group_1')
    #IssueFormAggressiveMove( ScenarioInfo.CybranUnits, ScenarioUtils.MarkerToPosition( 'Cybran_Path_1' ), 'AttackFormation', 0 )
    OffsetAggressiveMove( ScenarioInfo.CybranUnits, ScenarioUtils.MarkerToPosition( 'Cybran_Path_1' ))
    OffsetMove( ScenarioInfo.CybranUnits, ScenarioUtils.MarkerToPosition( 'Cybran_Path_2' ))
    OffsetAggressiveMove( ScenarioInfo.CybranUnits, ScenarioUtils.MarkerToPosition( 'Cybran_Path_3' ))
    OffsetAggressiveMove( ScenarioInfo.CybranUnits, ScenarioUtils.MarkerToPosition( 'Cybran_Path_4' ))
    OffsetAggressiveMove( ScenarioInfo.CybranUnits, ScenarioUtils.MarkerToPosition( 'Cybran_Path_5' ))
    OffsetAggressiveMove( ScenarioInfo.CybranUnits, ScenarioUtils.MarkerToPosition( 'Cybran_Path_6' ))
    OffsetAggressiveMove( ScenarioInfo.CybranUnits, ScenarioUtils.MarkerToPosition( 'Cybran_Path_7' ))

    ScenarioInfo.CybranSpiders = ScenarioUtils.CreateArmyGroup( 'Cybran', 'Spiders' )
    OffsetMove( ScenarioInfo.CybranSpiders, ScenarioUtils.MarkerToPosition( 'Fighting_Area_2_1' ))
    IssueMove( ScenarioInfo.CybranSpiders, ScenarioUtils.MarkerToPosition( 'Cybran_Path_2' ))
    IssueMove( ScenarioInfo.CybranSpiders, ScenarioUtils.MarkerToPosition( 'Cybran_Path_3' ))
    IssueMove( ScenarioInfo.CybranSpiders, ScenarioUtils.MarkerToPosition( 'Cybran_Path_4' ))
    IssueMove( ScenarioInfo.CybranSpiders, ScenarioUtils.MarkerToPosition( 'Cybran_Path_5' ))
    IssueMove( ScenarioInfo.CybranSpiders, ScenarioUtils.MarkerToPosition( 'Cybran_Path_6' ))
    IssueMove( ScenarioInfo.CybranSpiders, ScenarioUtils.MarkerToPosition( 'Cybran_Path_7' ))
    IssueMove( ScenarioInfo.CybranSpiders, ScenarioUtils.MarkerToPosition( 'Cybran_Path_6' ))

    ForkThread( CybranFlip )
end

# Cybran flip to become allied with the player and hostile to the Seraphim
function CybranFlip()
    WaitSeconds(10)
    SetAlliance( Player, Cybran, 'Ally' )
    SetAlliance( Cybran, Player, 'Ally' )
    SetAlliance( Cybran, Seraphim, 'Enemy' )
    SetAlliance( Seraphim, Cybran, 'Enemy' )

    #IssueClearCommands(ScenarioInfo.CybranUnits)
    #IssueClearCommands(ScenarioInfo.CybranSpiders)

    IssueClearCommands( ScenarioInfo.UEFUnits )
    OffsetAggressiveMove( ScenarioInfo.UEFUnits, ScenarioUtils.MarkerToPosition( 'Cybran_Path_2' ))
    OffsetAggressiveMove( ScenarioInfo.UEFUnits, ScenarioUtils.MarkerToPosition( 'Cybran_Path_3' ))
    OffsetAggressiveMove( ScenarioInfo.UEFUnits, ScenarioUtils.MarkerToPosition( 'Cybran_Path_7' ))
end

# Cybran naval reinforcements show up
function CybranNaval()

    local units = ScenarioUtils.CreateArmyGroup('Cybran', 'Naval_Group_1')
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Cybran_Naval_Path_1' ))
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Cybran_Naval_Path_2' ))
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Cybran_Naval_Path_3' ))
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))

    units = ScenarioUtils.CreateArmyGroup('Cybran', 'Naval_Group_2')
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Cybran_Naval_Path_4' ))
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Cybran_Naval_Path_5' ))
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Cybran_Naval_Path_6' ))
    #OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))

    ScenarioInfo.Crab = ScenarioUtils.CreateArmyUnit( 'Cybran', 'Crab' )
    ScenarioFramework.CreateUnitDeathTrigger( CrabDied, ScenarioInfo.Crab)
    IssueMove({ ScenarioInfo.Crab }, ScenarioUtils.MarkerToPosition( 'Cybran_Naval_Path_3' ))
    IssueAggressiveMove({ ScenarioInfo.Crab }, ScenarioUtils.MarkerToPosition( 'Crab_Destination' ))

    if ScenarioInfo.SeraphimFighters then
        for k, unit in ScenarioInfo.SeraphimFighters do
            if (unit and (not unit:IsDead())) then
                unit:Kill()
            end
        end
    end
end

# Seraphim send reinforcements on transports in the NE
function SeraphimTransports()

    ScenarioInfo.SeraphimTransport1 = ScenarioUtils.CreateArmyUnit( 'Seraphim', 'Transport1' )
    ScenarioInfo.SeraphimTransport2 = ScenarioUtils.CreateArmyUnit( 'Seraphim', 'Transport2' )
    ScenarioInfo.SeraphimTransport3 = ScenarioUtils.CreateArmyUnit( 'Seraphim', 'Transport3' )
    ScenarioInfo.SeraphimTransport4 = ScenarioUtils.CreateArmyUnit( 'Seraphim', 'Transport4' )
    ScenarioInfo.SeraphimTransport5 = ScenarioUtils.CreateArmyUnit( 'Seraphim', 'Transport5' )
    ScenarioInfo.SeraphimTransport6 = ScenarioUtils.CreateArmyUnit( 'Seraphim', 'Transport6' )
    ScenarioInfo.SeraphimGroundTransportees1 = ScenarioUtils.CreateArmyGroup('Seraphim', 'Transport_Group_1')
    ScenarioInfo.SeraphimGroundTransportees2 = ScenarioUtils.CreateArmyGroup('Seraphim', 'Transport_Group_2')
    ScenarioInfo.SeraphimGroundTransportees3 = ScenarioUtils.CreateArmyGroup('Seraphim', 'Transport_Group_3')
    ScenarioInfo.SeraphimGroundTransportees4 = ScenarioUtils.CreateArmyGroup('Seraphim', 'Transport_Group_4')
    ScenarioInfo.SeraphimGroundTransportees5 = ScenarioUtils.CreateArmyGroup('Seraphim', 'Transport_Group_5')
    ScenarioInfo.SeraphimGroundTransportees6 = ScenarioUtils.CreateArmyGroup('Seraphim', 'Transport_Group_6')

    # Load 'em up
    IssueTransportLoad(ScenarioInfo.SeraphimGroundTransportees1, ScenarioInfo.SeraphimTransport1)
    IssueTransportLoad(ScenarioInfo.SeraphimGroundTransportees2, ScenarioInfo.SeraphimTransport2)
    IssueTransportLoad(ScenarioInfo.SeraphimGroundTransportees3, ScenarioInfo.SeraphimTransport3)
    IssueTransportLoad(ScenarioInfo.SeraphimGroundTransportees4, ScenarioInfo.SeraphimTransport4)
    IssueTransportLoad(ScenarioInfo.SeraphimGroundTransportees5, ScenarioInfo.SeraphimTransport5)
    IssueTransportLoad(ScenarioInfo.SeraphimGroundTransportees6, ScenarioInfo.SeraphimTransport6)
    ForkThread(MoveTransport2)
end

function MoveTransport2()
    WaitSeconds(10)

    # Spawn in the UEF turret and the engineer that "built" it, now working on a radar building
    ScenarioUtils.CreateArmyUnit( 'Player', 'Turret' )
    ScenarioFramework.EngineerBuildUnits( 'Player', 'Engineer', 'Radar' )

    IssueTransportUnload({ ScenarioInfo.SeraphimTransport1 }, ScenarioUtils.MarkerToPosition( 'Seraphim_Unload_1' ))
    IssueTransportUnload({ ScenarioInfo.SeraphimTransport2 }, ScenarioUtils.MarkerToPosition( 'Seraphim_Unload_2' ))
    IssueTransportUnload({ ScenarioInfo.SeraphimTransport3 }, ScenarioUtils.MarkerToPosition( 'Seraphim_Unload_3' ))
    IssueTransportUnload({ ScenarioInfo.SeraphimTransport4 }, ScenarioUtils.MarkerToPosition( 'Seraphim_Unload_4' ))
    IssueTransportUnload({ ScenarioInfo.SeraphimTransport5 }, ScenarioUtils.MarkerToPosition( 'Seraphim_Unload_5' ))
    IssueTransportUnload({ ScenarioInfo.SeraphimTransport6 }, ScenarioUtils.MarkerToPosition( 'Seraphim_Unload_6' ))

    IssueMove({ ScenarioInfo.SeraphimTransport1,
                ScenarioInfo.SeraphimTransport2,
                ScenarioInfo.SeraphimTransport3,
                ScenarioInfo.SeraphimTransport4,
                ScenarioInfo.SeraphimTransport5,
                ScenarioInfo.SeraphimTransport6 }, ScenarioUtils.MarkerToPosition( 'Transport_Exit' ))

    local units = ScenarioUtils.CreateArmyGroup('Seraphim', 'Fighting_Group_6')
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))
    #OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Seraphim_Final_Destination' ), 'AttackFormation', 0 )

    units = ScenarioUtils.CreateArmyGroup('Seraphim', 'Fighting_Group_8')
    OffsetMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))
    #OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Seraphim_Final_Destination' ), 'AttackFormation', 0 )

    WaitSeconds(25)
    IssueClearCommands(ScenarioInfo.SeraphimGroundTransportees1)
    #IssuePatrol( ScenarioInfo.SeraphimGroundTransportees1, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_2' ))
    #IssuePatrol( ScenarioInfo.SeraphimGroundTransportees1, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_3' ))
    OffsetAggressiveMove( ScenarioInfo.SeraphimGroundTransportees1, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))

    IssueClearCommands(ScenarioInfo.SeraphimGroundTransportees2)
    #IssuePatrol( ScenarioInfo.SeraphimGroundTransportees2, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_2' ))
    #IssuePatrol( ScenarioInfo.SeraphimGroundTransportees2, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_3' ))
    OffsetAggressiveMove( ScenarioInfo.SeraphimGroundTransportees2, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))

    IssueClearCommands(ScenarioInfo.SeraphimGroundTransportees3)
    #IssuePatrol( ScenarioInfo.SeraphimGroundTransportees3, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_2' ))
    #IssuePatrol( ScenarioInfo.SeraphimGroundTransportees3, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_3' ))
    OffsetAggressiveMove( ScenarioInfo.SeraphimGroundTransportees3, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))

    IssueClearCommands(ScenarioInfo.SeraphimGroundTransportees4)
    #IssuePatrol( ScenarioInfo.SeraphimGroundTransportees4, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_2' ))
    #IssuePatrol( ScenarioInfo.SeraphimGroundTransportees4, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_3' ))
    OffsetAggressiveMove( ScenarioInfo.SeraphimGroundTransportees4, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))

    IssueClearCommands(ScenarioInfo.SeraphimGroundTransportees5)
    #IssuePatrol( ScenarioInfo.SeraphimGroundTransportees5, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_2' ))
    #IssuePatrol( ScenarioInfo.SeraphimGroundTransportees5, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_3' ))
    OffsetAggressiveMove( ScenarioInfo.SeraphimGroundTransportees5, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))

    IssueClearCommands(ScenarioInfo.SeraphimGroundTransportees6)
    #OffsetAggressiveMove( ScenarioInfo.SeraphimGroundTransportees6, ScenarioUtils.MarkerToPosition( 'Seraphim_Final_Destination' ))
    OffsetAggressiveMove( ScenarioInfo.SeraphimGroundTransportees6, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_4' ))

    WaitSeconds(30)
    if ScenarioInfo.SeraphimTransport1 and not ScenarioInfo.SeraphimTransport1:IsDead() then
        ScenarioInfo.SeraphimTransport1:Destroy()
    end
    if ScenarioInfo.SeraphimTransport2 and not ScenarioInfo.SeraphimTransport2:IsDead() then
        ScenarioInfo.SeraphimTransport2:Destroy()
    end
    if ScenarioInfo.SeraphimTransport3 and not ScenarioInfo.SeraphimTransport3:IsDead() then
        ScenarioInfo.SeraphimTransport3:Destroy()
    end
    if ScenarioInfo.SeraphimTransport4 and not ScenarioInfo.SeraphimTransport4:IsDead() then
        ScenarioInfo.SeraphimTransport4:Destroy()
    end
    if ScenarioInfo.SeraphimTransport5 and not ScenarioInfo.SeraphimTransport5:IsDead() then
        ScenarioInfo.SeraphimTransport5:Destroy()
    end
    if ScenarioInfo.SeraphimTransport6 and not ScenarioInfo.SeraphimTransport6:IsDead() then
        ScenarioInfo.SeraphimTransport6:Destroy()
    end

end

# Seraphim send air including mega-bomber to end the NE battle
function SendBomber1()

    ScenarioInfo.Bomber = ScenarioUtils.CreateArmyUnit( 'Seraphim', 'Bomber' )
    ScenarioInfo.BomberEscorts = ScenarioUtils.CreateArmyGroup('Seraphim', 'Bomber_Escorts')
    IssueGuard(ScenarioInfo.BomberEscorts, ScenarioInfo.Bomber )

    ScenarioInfo.BomberTarget:SetCanTakeDamage( true )
    ScenarioInfo.BomberTarget:SetCanBeKilled( true )
    IssueAttack({ ScenarioInfo.Bomber }, ScenarioInfo.BomberTarget )
    IssueMove({ ScenarioInfo.Bomber }, ScenarioUtils.MarkerToPosition( 'Bomber_Intermediate' ))
    IssueAttack({ ScenarioInfo.Bomber }, ScenarioInfo.Crab )
    IssueMove({ ScenarioInfo.Bomber }, ScenarioUtils.MarkerToPosition( 'Bomber_Destination' ))

    #IssueMove({ ScenarioInfo.Bomber }, ScenarioUtils.MarkerToPosition( 'Bomber_Holding_Pattern_3' ))
    #IssuePatrol({ ScenarioInfo.Bomber }, ScenarioUtils.MarkerToPosition( 'Bomber_Holding_Pattern_1' ))
    #IssuePatrol({ ScenarioInfo.Bomber }, ScenarioUtils.MarkerToPosition( 'Bomber_Holding_Pattern_2' ))
    #IssuePatrol({ ScenarioInfo.Bomber }, ScenarioUtils.MarkerToPosition( 'Bomber_Holding_Pattern_3' ))

    #ForkThread( KillBomber )
end

function KillBomber()
    WaitSeconds(40)
    if ScenarioInfo.Bomber and not ScenarioInfo.Bomber:IsDead() then
        ScenarioInfo.Bomber:Destroy()
    end
end

# Nukes launch and the anti-nukes are spawned in (loaded!) to the Seraphim base
function SendNukes()
    # Seraphim Antinukes, with some ammo
    ScenarioInfo.Antinuke1 = ScenarioUtils.CreateArmyUnit( 'Seraphim', 'Antinuke_1' )
    ScenarioInfo.Antinuke1:GiveTacticalSiloAmmo(3)
    ScenarioInfo.Antinuke2 = ScenarioUtils.CreateArmyUnit( 'Seraphim', 'Antinuke_2' )
    ScenarioInfo.Antinuke2:GiveTacticalSiloAmmo(3)
    ScenarioInfo.Antinuke3 = ScenarioUtils.CreateArmyUnit( 'Seraphim', 'Antinuke_3' )
    ScenarioInfo.Antinuke3:GiveTacticalSiloAmmo(3)

    local units = ScenarioUtils.CreateArmyGroup('Seraphim', 'Fighting_Group_6')
    OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_1' ), 'AttackFormation', 0 )
    OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Seraphim_Final_Destination' ), 'AttackFormation', 0 )

    units = ScenarioUtils.CreateArmyGroup('Seraphim', 'Fighting_Group_8')
    OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Fighting_Area_1_1' ), 'AttackFormation', 0 )
    OffsetAggressiveMove( units, ScenarioUtils.MarkerToPosition( 'Seraphim_Final_Destination' ), 'AttackFormation', 0 )

    ForkThread( LaunchNukes )
end

function LaunchNukes()
    # Stagger when they launch so that the anti-nukes have an easy time shooting them down one by one
    # (if they are synchronized, there is a chance that multiple anti-nukes will shoot down the same nuke)
    #LOG('*DEBUG: --Nuking--')
    WaitSeconds(1)
    IssueNuke({ ScenarioInfo.PlayerNuke1 }, ScenarioInfo.Antinuke1:GetPosition() )
    WaitSeconds(2)
    IssueNuke({ ScenarioInfo.PlayerNuke2 }, ScenarioUtils.MarkerToPosition( 'Nuke_Target' ) )
    WaitSeconds(1)
    IssueNuke({ ScenarioInfo.PlayerNuke3 }, ScenarioInfo.Antinuke3:GetPosition() )
end

# Wrap things up
function CallMovieHere()
    NukesKilled = NukesKilled + 1
    if NukesKilled == 3 then
        ForkThread( PlayMovieHere )
    end
end

function PlayMovieHere()
    # Call the movie here

    # Commented out; nukes aren't ending the demo anymore
    #WaitSeconds(3)
    #EndDemo()
end

function SendBomber2()
    # Commander is vulnerable (one bomb will take him out)
    ScenarioInfo.Commander:SetCanTakeDamage( true )
    ScenarioInfo.Commander:SetCanBeKilled( true )

    # Set the T3 power stations low on health to add to the exposive carnage
    local BaseUnits = GetUnitsInRect( ScenarioUtils.AreaToRect( 'UEF_Base_Area' ))
    for k, unit in BaseUnits do
        local id = unit:GetUnitId()
        if string.find( id, "ueb" ) then # T3 power stations = ueb1301
            unit:AdjustHealth( unit, (unit:GetHealth() - 1) * -1 )
        end
    end

    local Bomber1 = ScenarioUtils.CreateArmyUnit( 'Seraphim', 'Final_Bomber_1' )
    local Bomber2 = ScenarioUtils.CreateArmyUnit( 'Seraphim', 'Final_Bomber_2' )
    local Bomber3 = ScenarioUtils.CreateArmyUnit( 'Seraphim', 'Final_Bomber_3' )

    IssueAttack({ Bomber1 }, ScenarioInfo.UnitNames[Player]['Final_Bomber_Target_2'])
    IssueAttack({ Bomber2 }, ScenarioInfo.UnitNames[Player]['Final_Bomber_Target_1'])
    IssueAttack({ Bomber3 }, ScenarioInfo.Commander )
    IssueMove({ Bomber1,
                Bomber2,
                Bomber3 }, ScenarioUtils.MarkerToPosition( 'Transport_Exit' ))

end

function MakeCrabFragile()
    ForkThread( DelayCrabFragile )
end

function DelayCrabFragile()
    WaitSeconds(5)
    ScenarioInfo.Crab:AdjustHealth( ScenarioInfo.Crab, -(ScenarioInfo.Crab:GetHealth() - 1))
end

function CrabDied()
    ForkThread( KillAmphibious )
end

function KillAmphibious()
    WaitSeconds( 0.5 )
    local CybranAmphibiousUnits = GetUnitsInRect( ScenarioUtils.AreaToRect( 'Unit_Death_Area' ))
    for k, unit in CybranAmphibiousUnits do
        if k != 'n' then
            if unit and not unit:IsDead() and (unit:GetArmy() == Cybran) then
                unit:Kill()
            end
        end
    end
end

function OffsetMove( ArmyGroup, Destination )

    if ArmyGroup then
        local xAvg, yAvg, zAvg = unpack( GetAveragePosition( ArmyGroup ))
        local xDest, yDest, zDest = unpack(Destination)
        local xMove = xDest - xAvg
        local yMove = yDest - yAvg
        local zMove = zDest - zAvg
        for k, unit in ArmyGroup do
            if not unit:IsDead() then
                local x, y, z = unpack(unit:GetPosition() )
                IssueMove( {unit}, {x + xMove, y, z + zMove} )
            end
        end
    else
        error('*ERROR* Attempting to OffsetMove a non-existent group: ' .. arg[arg['n']], 2)
    end
end

function OffsetAggressiveMove( ArmyGroup, Destination )

    if ArmyGroup then
        local xAvg, yAvg, zAvg = unpack( GetAveragePosition( ArmyGroup ))
        local xDest, yDest, zDest = unpack(Destination)
        local xMove = xDest - xAvg
        local yMove = yDest - yAvg
        local zMove = zDest - zAvg
        for k, unit in ArmyGroup do
            if not unit:IsDead() then
                local x, y, z = unpack(unit:GetPosition() )
                IssueAggressiveMove( {unit}, {x + xMove, y, z + zMove} )
            end
        end
    else
        error('*ERROR* Attempting to OffsetMove a non-existent group: ' .. arg[arg['n']], 2)
    end
end

function GetAveragePosition( ArmyGroup )
    local xTotal = 0
    local yTotal = 0
    local zTotal = 0
    local numUnits = 0
    for k, unit in ArmyGroup do
        if unit and not unit:IsDead() then
            local x, y, z = unpack( unit:GetPosition())
            xTotal = x + xTotal
            yTotal = y + yTotal
            zTotal = z + zTotal
            numUnits = numUnits + 1
        end
    end
    local AveragePosition = { xTotal / numUnits, yTotal / numUnits, zTotal / numUnits }
    return AveragePosition
end